#version 330
#extension GL_EXT_gpu_shader4 : enable
// twinkle starfieldMod01.fsh  by   TheNosiriN

//https://www.shadertoy.com/view/3sBBDV
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define RES 0.2


// perlin noise from: https://www.shadertoy.com/view/4sc3z2
#define MOD3 vec3(.1031,.11369,.13787)

vec3 hash33(vec3 p3)
{
	p3 = fract(p3 * MOD3);
    p3 += dot(p3, p3.yxz+19.19);
    return -1.0 + 2.0 * fract(vec3((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y, (p3.y+p3.z)*p3.x));
}
float perlin_noise(vec3 p)
{
    vec3 pi = floor(p);
    vec3 pf = p - pi;
    
    vec3 w = pf * pf * (3.0 - 2.0 * pf);
    
    return 	mix(
        		mix(
                	mix(dot(pf - vec3(0, 0, 0), hash33(pi + vec3(0, 0, 0))), 
                        dot(pf - vec3(1, 0, 0), hash33(pi + vec3(1, 0, 0))),
                       	w.x),
                	mix(dot(pf - vec3(0, 0, 1), hash33(pi + vec3(0, 0, 1))), 
                        dot(pf - vec3(1, 0, 1), hash33(pi + vec3(1, 0, 1))),
                       	w.x),
                	w.z),
        		mix(
                    mix(dot(pf - vec3(0, 1, 0), hash33(pi + vec3(0, 1, 0))), 
                        dot(pf - vec3(1, 1, 0), hash33(pi + vec3(1, 1, 0))),
                       	w.x),
                   	mix(dot(pf - vec3(0, 1, 1), hash33(pi + vec3(0, 1, 1))), 
                        dot(pf - vec3(1, 1, 1), hash33(pi + vec3(1, 1, 1))),
                       	w.x),
                	w.z),
    			w.y);
}


float hash21(vec2 p)
{
 	p = fract( p*vec2(123.34, 456.21) );
    p += dot(p, p+45.32);
    return fract(p.x*p.y);
}


float star(vec2 p, float time)
{
	float d = length(p);
    float m = (max(0.2, abs(sin(time))) * 0.02) / d;
    
    m *= smoothstep(1.0, 0.2, d);
    
    return m;
}


vec3 starField(vec2 uv)
{
    vec3 col = vec3(0);
    
    vec2 gv = fract(uv) - 0.5;
    vec2 id = floor(uv);
    
    for (int x=-1; x<=1; x++){
        for (int y=-1; y<=1; y++)
        {
            vec2 offset = vec2(x, y);
            
            float n = hash21(id + offset);
            float star = star(gv - offset - (vec2(n, fract(n*100.0)) - 0.5), iTime*fract(n*135.246));
            float size = min(1.0, fract(n*1234.567) + 0.1);
            
            col += star * size;
        }
    }
    
    return col;
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy/iResolution.y)/RES;
    vec3 coords = vec3(vec2(uv.x, uv.y + iTime*0.03), iTime*0.3);
    
    
    vec3 stars = starField( vec2(coords.x, coords.y)*5.0 );
    
    
    float warpAmplitude = 10.0;
   	float warpFrequency = 0.04;
    
    vec3 clouds = vec3( perlin_noise(coords) ) * 0.3;
    
    vec3 cloudsCol = 0.5 + 0.5*cos((coords*2.0)+vec3(0,3,9)); //color
    clouds *= cloudsCol;
    stars *= cloudsCol*2.0;
    stars *= clouds+0.5;
    vec3 col = clouds + stars;
   
    
    // Output to screen
    gl_FragColor = vec4(col,1.0);
}